IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Cajas_Cierre') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CPJ_Cajas_Cierre]
END
GO


CREATE PROCEDURE [dbo].[CPJ_Cajas_Cierre] 	@pJson VARCHAR(8000)

AS
--VERSION: 01/12/2021
DECLARE @Mensaje			VARCHAR(100)
BEGIN TRY
BEGIN TRAN

Declare @pFecha_Nueva     DateTime
Declare @pId_Periodo_Caja Int
Declare @pId_Usuario      Int
Declare @pId_Sucursal     Int


SET @pFecha_Nueva		    = ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Nueva')),getdate())
SET @pId_Periodo_Caja		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Periodo_Caja')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Sucursal			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Sucursal')), 0)
 
IF @pId_Periodo_Caja = 0 
	BEGIN
	    SET @Mensaje = 'El cbte no debe estar en Estado Anulado'
		ROLLBACK
		SELECT	 1099		    	AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,@Mensaje			AS ErrorMessage
		RETURN 1
	END 

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)

Declare @Nuevo_Periodo    Int
Declare @Caja_Abierta     SmallInt
Declare @SaldoEfectivo    Decimal(14,2)
Declare @SaldoTotal       Decimal(14,2)
Declare @Saldo_Valores    Decimal(14,2)
DECLARE @IMPORTE_CAJA     DECIMAL(14,2)

Declare @Id_Trans         INT
Declare @Fecha            DATETIME
Declare @Id_Tipo_Cbte     Char(4)
Declare @Id_Estado_Cbte   SmallInt
DECLARE @Id_Empresa			SMALLINT
DECLARE @Id_Sucursal		SMALLINT
DECLARE @Cbte_Grupo			INT
DECLARE @Comprobante_Nro	INT
DECLARE @Id_Taller			VARCHAR(10)
DECLARE @Id_Proceso			VARCHAR(10)
DECLARE @Id_Proveedor		INT
DECLARE @Signo				SMALLINT
DECLARE @Id_Dep_Fisico		CHAR(3)
DECLARE @Id_Dep_Logico		CHAR(3)
DECLARE @Porc_DescEspecial	DECIMAL(5, 2)
DECLARE @Porc_DescFin		DECIMAL(5, 2)
DECLARE @Porc_Iva			DECIMAL(5, 2)
DECLARE @Porc_Iva2			DECIMAL(5, 2)
DECLARE @Imp_Neto			DECIMAL(12, 2)
DECLARE @Imp_DescEspecial	DECIMAL(12, 2)
DECLARE @Imp_DescFin		DECIMAL(12, 2)
DECLARE @Imp_Bonificacion	DECIMAL(12, 2)
DECLARE @Imp_Gravado		DECIMAL(12, 2)
DECLARE @Imp_Exento			DECIMAL(12, 2)
DECLARE @Imp_IVA			DECIMAL(12, 2)
DECLARE @Imp_IVA2			DECIMAL(12, 2)
DECLARE @Imp_Percepcion_IB	DECIMAL(12, 2)
DECLARE @Imp_Percepcion_Iva DECIMAL(12, 2)
DECLARE @Imp_Total			DECIMAL(12, 2)
DECLARE @Bultos				SMALLINT
DECLARE @NroImpresion		INT
DECLARE @Exportado			TINYINT
DECLARE @Dir_Entrega		VARCHAR(255)
DECLARE @Id_Pais			CHAR(3)
DECLARE @Id_Provincia		CHAR(3)
DECLARE @Id_Localidad		INT
DECLARE @Porc_Iva3			DECIMAL(5, 2)
DECLARE @Imp_Gravado2		DECIMAL(12, 2)
DECLARE @Imp_Gravado3		DECIMAL(12, 2)
DECLARE @Imp_NoGravado		DECIMAL(12, 2)
DECLARE @Imp_IVA3			DECIMAL(12, 2)
DECLARE @Imp_Percep			DECIMAL(12, 2)
DECLARE @Saldo				DECIMAL(12, 2)
DECLARE @Periodo_Iva		DATETIME
DECLARE @Periodo			DATETIME
DECLARE @Id_Cond_Pago_Item	TINYINT
DECLARE @Id_Tipo_Reten		VARCHAR(10)
DECLARE @Cant_Cuotas		SMALLINT
DECLARE @Id_Producto		VARCHAR(14)
DECLARE @Id_Formula			VARCHAR(15)
DECLARE @Cantidad			DECIMAL(12, 4)
DECLARE @Id_Transportista	INT
DECLARE @Destinatario		VARCHAR(100)
DECLARE @Cuit				VARCHAR(19)
DECLARE @Doc_Nro			BIGINT
DECLARE @Id_Iva				CHAR(3)
DECLARE @Cant_Batch			SMALLINT
DECLARE @Fecha_Perm_Embar	DATETIME
DECLARE @Saldo_Iva_Recup	DECIMAL(12, 2)
DECLARE @Suc_Destina		SMALLINT
DECLARE @Id_Asiento			INT
DECLARE @Id_Valor			INT
DECLARE @Cai				DECIMAL(14, 0)
DECLARE @Des_Anio			TINYINT
DECLARE @Des_Aduana			CHAR(3)
DECLARE @Des_Destina		CHAR(4)
DECLARE @Des_Nro			INT
DECLARE @Des_Verif			CHAR(1)
DECLARE @Id_Cobrador		VARCHAR(10)
DECLARE @Remito_Nro			VARCHAR(25)
DECLARE @Pedido_Nro			VARCHAR(25)
DECLARE @Id_Tarjeta			VARCHAR(11)
DECLARE @Tarjeta_Nro		VARCHAR(25)
DECLARE @Cantidad_Saldo		DECIMAL(12, 4)
DECLARE @Saldo_Anterior		DECIMAL(12, 2)
DECLARE @NRO_DJAI			VARCHAR(30)
DECLARE @Cantidad_Equiv		DECIMAL(12, 4)
DECLARE @Id_Trans_Origen	INT
DECLARE @Id_Sede_Origen		SMALLINT
DECLARE @Email				VARCHAR(8000)
DECLARE @Patente_Transporte VARCHAR(7)
DECLARE @Patente_Transporte_Acoplado VARCHAR(7)
DECLARE @Plazo_Venc			SMALLINT
DECLARE @Porc_Bonificacion	DECIMAL(5,2)
DECLARE @Fecha_Estimada		DATETIME
DECLARE @Persona_Recibe		VARCHAR(100)
DECLARE @Observacion		VARCHAR(8000)
DECLARE @Id_Lista			SMALLINT
DECLARE @Id_Lista_Contrato	SMALLINT
DECLARE @Id_Vendedor		VARCHAR(10)
DECLARE @Nro_Perm_Embarque	VARCHAR(20)
DECLARE @Id_Puerto			CHAR(3)
DECLARE @Id_Cond_Vta		CHAR(10)
DECLARE @Cbte_Nro_Externo	VARCHAR(25)
DECLARE @Nota_Part1			VARCHAR(100)
DECLARE @Nota_Part2			VARCHAR(100)
DECLARE @Id_Centro_Costo	CHAR(10)
DECLARE @Id_Camp			SMALLINT
DECLARE @Flag_Lote			TINYINT
DECLARE @Compromete_Factura SMALLINT
DECLARE @Descrip_Cbte		VARCHAR(100)
DECLARE @Importe			DECIMAL(12, 2)
DECLARE @Importe_Con_Signo	DECIMAL(12, 2)
DECLARE @Id_Cliente_Ref		INT
DECLARE @Renglon_Nro		SMALLINT
DECLARE @Id_Estado_Mov_Caja	INT
DECLARE @Descripcion		VARCHAR(100)
DECLARE @Id_Tipo_Mov_Caja	SMALLINT
DECLARE @Id_Concepto		INT
DECLARE @Item				SMALLINT
DECLARE @Id_Estado_Concepto	SMALLINT
DECLARE @Id_Moneda          CHAR(3)


----- VALORES


DECLARE @Id_Valor_Origen			INT
DECLARE @Id_Estado_Valor			SMALLINT
DECLARE @Id_Cliente					INT
DECLARE @Id_Banco					SMALLINT
DECLARE @Id_Cta_Banco				SMALLINT
DECLARE @Id_Mov_Caja				INT
DECLARE @Cotizacion					DECIMAL(9,4)
DECLARE @Id_Periodo_Caja			INT
DECLARE @Propio						TINYINT
DECLARE @Transferible				TINYINT
DECLARE @Id_Chequera				INT
DECLARE @Renglon_Nro_Caja			SMALLINT
DECLARE @Flag_Conciliado			TINYINT
DECLARE @Fecha_Conci				DATETIME
DECLARE @Tarjeta_Cant_Cuotas		TINYINT
DECLARE @Tarjeta_Imp_Cuota		    DECIMAL(12,2)
DECLARE @Tarjeta_Crit_Cuota		    CHAR(1)
DECLARE @pTarjeta_Cod_Seguridad  	INT	
DECLARE @pTarjeta_Cod_Autoriz		INT
DECLARE @Flag_Existe_Tipo_Valor	    TINYINT
DECLARE @Id_Motivo_Estado			SMALLINT
DECLARE @Lote						VARCHAR(20)
DECLARE @Id_Mov_Cta_Banco		    INT

--------------------

Set @Nuevo_Periodo  = Isnull((SELECT MAX(Id_Periodo_Caja) FROM Cajas_Periodos),0)+1
Set @Caja_Abierta = 1 --Abieta

--Creo nuevo Periodo de Caja

	Select * into #nueva_caja from Cajas_Periodos where Id_Periodo_Caja = @pId_Periodo_Caja

	Update #nueva_caja set Fecha_Corresp   = @pFecha_Nueva
						  ,Id_Periodo_Caja = @Nuevo_Periodo
						  ,Id_Estado_Caja  = @Caja_Abierta
						  ,Fecha_Apertura  = Getdate()

	Insert into Cajas_Periodos 
	       select * from #nueva_caja

/*

! Dest# = XParam.Fetch('Caj_Per_Val_Rec')
! Lo tomamos de la base por si lo cierren y de esta forma lo releemos.
 IF CAJ:Id_Caja_Cierre = 0
    Dest# = Sql.Fetch(1,'SELECT Valor_Integer FROM xParametros WHERE IdParametro = ''Caj_Per_Val_Rec'' AND SetDatos = 1')
   ELSE
   IF NOT XRESP('SELECT MAX(Id_Periodo_Caja) from Cajas_Periodos where Id_Caja = '& CAJ:Id_Caja_Cierre &' And Id_Estado_Caja =  1')
      IF XR:COL1 <> 0
         Dest# = XR:COL1 
        ELSE 
         MESSAGE('No existe un Perodo de Caja Destino abierto','ATENCIN',ICON:HAND)
      END 
   END 
 END
!---------------------------------------


 IF Dest#
    IF  Loc:Id_Periodo_Caja = Dest#  !si el destnio es el mismo que cierro, actualizo el parammetro
        nada# = Sql.Exec('UPDATE xParametros SET Valor_Integer = '& Loc:Id_Periodo_Caja2 &' WHERE IdParametro = ''Caj_Per_Val_Rec'' AND SetDatos = 1')
    ELSE
        Loc:Id_Periodo_Caja2 = Dest#
    END!IF
 END!IF

*/

-- Valores detalle
 
          Select *  Into #New_Valores from valores v  where v.Id_Periodo_Caja = @pId_Periodo_Caja 
	                          AND v.Id_Tipo_Val <> 'EFE'
                              AND v.Id_estado_valor = 3 
							  and (SELECT C.ID_ESTADO_CBTE FROM CBTES C, VALORES_MOV M WHERE C.ID_TRANS = M.ID_TRANS AND M.ID_VALOR = v.id_valor
                                 AND M.RENGLON_NRO = 1 ) <> 3 
-- Saldo Efectivo

          SELECT V.Id_Moneda,SUM(V.Importe) Importe Into #Suma_Efectivo
                 FROM VALORES V,Cajas_Mov C, Valores_Mov M, Cbtes CB, Cbtes_Tipos T
                 WHERE C.Id_Periodo_Caja IN (2)
                 AND V.Id_Valor = M.Id_valor 
                 AND CB.ID_TRANS = C.ID_TRANS 
                 AND CB.ID_TIPO_CBTE = T.ID_TIPO_CBTE 
                 AND ISNULL(T.COMPROMETE_BANKING, 0) NOT IN (1,-1) 
                 AND V.Id_Tipo_Val = 'EFE'
                 AND C.Id_Trans = M.Id_Trans AND C.Renglon_Nro = M.Renglon_Nro_Caja 
                 and M.Renglon_Nro = (SELECT MAX(VM.Renglon_Nro)  
                         FROM Valores_Mov VM 
                         WHERE VM.Id_Periodo_Caja = M.Id_Periodo_Caja
                         AND VM.Id_Valor = M.Id_Valor 
                         AND VM.Renglon_Nro_Caja = M.Renglon_Nro_Caja
                         AND VM.Id_Trans = C.Id_Trans 
                         AND C.Id_Estado_Mov_Caja = 2) 
                 AND C.Id_Estado_Mov_Caja = 2 AND C.Importe > 0
                 GROUP BY V.Id_Moneda,V.Cotizacion

          SELECT V.Id_Moneda,SUM(V.Importe*-1) Importe Into #Resta_Efectivo
                 FROM VALORES V,Cajas_Mov C, Valores_Mov M, Cbtes CB, Cbtes_Tipos T
                 WHERE C.Id_Periodo_Caja = 2
                 AND V.Id_Valor = M.Id_valor 
                 AND CB.ID_TRANS = C.ID_TRANS 
                 AND CB.ID_TIPO_CBTE = T.ID_TIPO_CBTE 
                 AND ISNULL(T.COMPROMETE_BANKING, 0) NOT IN (1,-1)
                 AND V.Id_Tipo_Val = 'EFE'
                 AND C.Id_Trans = M.Id_Trans AND C.Renglon_Nro = M.Renglon_Nro_Caja 
                 and M.Renglon_Nro = (SELECT MAX(VM.Renglon_Nro) 
                        FROM Valores_Mov VM 
                         WHERE VM.Id_Periodo_Caja = M.Id_Periodo_Caja 
                         AND VM.Id_Valor = M.Id_Valor 
                         AND VM.Renglon_Nro_Caja = M.Renglon_Nro_Caja 
                         AND VM.Id_Trans = C.Id_Trans 
                         AND C.Id_Estado_Mov_Caja = 2) 
                 AND C.Id_Estado_Mov_Caja = 2 AND C.Importe < 0
                 GROUP BY V.Id_Moneda

				 Insert into #Suma_Efectivo Select * from #Resta_Efectivo

				 Select Id_Moneda,sum(isnull(Importe,0)) Importe 
				 from #Suma_Efectivo
				 Group by Id_Moneda

	             Set @SaldoEfectivo = ISNULL((Select sum(isnull(Importe,0)) From #Suma_Efectivo),0)

                 Set @Saldo_Valores = ISNULL((select Sum(isnull(Importe,0)) from #New_Valores),0)

                 Set @SaldoTotal = @Saldo_Valores + @SaldoEfectivo
				  
-- Genero Transaccion

		SET @Id_Trans		= ISNULL((SELECT MAX(Id_Trans) FROM Transacciones), 0) + 1
		INSERT INTO Transacciones 
		(Id_Trans,		Descripcion,						Fecha_Mov,
		Id_Usuario) 
		VALUES
		(@Id_Trans,	'Cierre de caja por SP', GETDATE(), 
		@pId_Usuario)
 
-- Genero Cajas_mov

	SET @Id_Concepto = dbo.CF_xParam('Trans_Concepto') 

		IF @SaldoTotal > 0
		   BEGIN
			  SET @Id_Tipo_Mov_Caja   = 4 --- e_Egr_Transf
			  SET @IMPORTE_CAJA       = Abs(@SaldoTotal) * -1
		   END
		ELSE
		   BEGIN
			  SET @Id_Tipo_Mov_Caja   = 5 --- e_Ing_Transf
			  SET @IMPORTE_CAJA       = Abs(@SaldoTotal)
		   END 
  
                     
		INSERT INTO Cajas_Mov 
		(Id_Trans,Renglon_Nro,Fecha,Id_Estado_Mov_Caja, Id_Periodo_Caja,Id_Tipo_Mov_Caja,Importe,Descripcion) 
		VALUES
		(@Id_Trans,	1, GETDATE(), 2, @Nuevo_Periodo, @Id_Tipo_Mov_Caja, @IMPORTE_CAJA,'TRASPASO DE SALDOS')


-- Genero Cajas_Mov_Conceptos
      

		INSERT INTO Cajas_Mov_Conceptos
		(Id_Trans,Id_Concepto,Item,Id_Estado_Concepto,Importe,Id_Periodo_Caja) 
		VALUES
		(@Id_Trans,@Id_Concepto, 1,0,@SaldoTotal*-1,@pId_Periodo_Caja) 


		INSERT INTO Cajas_Mov_Conceptos
		(Id_Trans,Id_Concepto,Item,Id_Estado_Concepto,Importe,Id_Periodo_Caja) 
		VALUES
		(@Id_Trans,@Id_Concepto, 2,0,@SaldoTotal,@Nuevo_Periodo)



-- GENERO CBTE EGRESO ------------------------------------

    SET @Id_Moneda          = dbo.CF_xParam('Moneda_Nacional')
	SET @Comprobante_Nro	= 0 
	SET @Importe			= 0 

	SET @Plazo_Venc			= 0
	SET @Saldo				= 0  
	SET @Imp_Gravado		= 0  
	SET @Imp_Neto			= 0  
	SET @Imp_Exento			= 0  
    SET @Imp_Total          = ABS(@SaldoTotal)
	SET @Id_Taller			= ''
	SET @Id_Proceso			= ''
	SET @Id_Proveedor		= 0
	SET @Signo				= 0
	SET	@Porc_DescFin		= 0
	SET @Porc_DescEspecial	= 0
	SET @Porc_Iva			= dbo.CF_xParam('Tasa_Iva_1')
	SET @Porc_Iva2			= dbo.CF_xParam('Tasa_Iva_2')
	SET @Imp_DescEspecial	= 0
	SET @Imp_DescFin		= 0
	SET @Imp_Bonificacion	= 0
	SET @Imp_Iva			= 0
	SET @Imp_Iva2			= 0
	SET @Imp_Percepcion_IB	= 0
	SET @Imp_Percepcion_Iva = 0
	SET @Bultos				= 0
	SET @NroImpresion		= 0
	SET @Exportado			= 0
	SET @Dir_Entrega		= ''
	SET @Porc_Iva3			= dbo.CF_xParam('Tasa_Iva_3')
	SET @Imp_Gravado2		= 0
	SET @Imp_Gravado3		= 0
	SET @Imp_NoGravado		= 0
	SET @Imp_IVA3			= 0
	SET @Imp_Percep			= 0
	SET @Id_Cond_Pago_Item	= 0
	SET @Id_Tipo_Reten		= ''
	SET @Cant_Cuotas		= 1
	SET @Id_Producto		= NULL
	SET @Id_Formula			= NULL
	SET @Cantidad			= 0
	SET @Id_Transportista	= 0
	SET @Cant_Batch			= 0
	SET @Fecha_Perm_Embar	= NULL
	SET @Saldo_Iva_Recup	= 0
	SET @Suc_Destina		= 0
	SET @Id_Asiento			= 0
	SET @Id_Valor			= 0
	SET @Cai				= 0	
	SET @Des_Anio			= 0
	SET @Des_Aduana			= ''
	SET @Des_Destina		= ''
	SET @Des_Nro			= 0
	SET @Des_Verif			= ''
	SET @Id_Cobrador		= ''
	SET @Remito_Nro			= ''
	SET @Pedido_Nro			= ''
	SET @Id_Tarjeta			= ''
	SET @Tarjeta_Nro		= ''
	SET @Cantidad_Saldo		= 0
	SET @Saldo_Anterior		= 0
	SET @NRO_DJAI			= ''
	SET @Cantidad_Equiv		= 0
	SET @Id_Trans_Origen	= 0
	SET @Id_Sede_Origen		= 0
	SET @Patente_Transporte = ''
	SET @Patente_Transporte_Acoplado = ''
	SET @Porc_Bonificacion	= 0
	SET @Fecha_Estimada		= NULL
	SET @Persona_Recibe		= ''
	SET @Observacion		= ''
	SET @Id_Vendedor		= ''
	SET @Nro_Perm_Embarque	= ''
	SET @Id_Puerto			= ''
	SET @Id_Cond_Vta		= ''
	SET @Cbte_Nro_Externo	= ''
	SET @Nota_Part1			= ''
	SET @Nota_Part2			= ''
	SET @Id_Centro_Costo	= ''
	SET @Id_Camp			= 0
    SET @Id_Tipo_Cbte = dbo.CF_xParam('Cbte_Tranf_Caja') 

	SET @Id_Tipo_Cbte = Isnull((Select T.Id_tipo_cbte from Cbtes_tipos T, Cbtes_Tipos_UN U 
                              Where u.Id_Tipo_Cbte_UN = @Id_Tipo_Cbte and t.Id_Tipo_Cbte = u.Id_Tipo_Cbte 
							  and t.id_sucursal = @pId_Sucursal),dbo.CF_xParam('Cbte_Tranf_Caja') )

	SELECT  @Id_Sucursal		= ISNULL(Id_Sucursal, 0),
			@Cbte_Grupo			= ISNULL(Cbte_Grupo, 0)
	FROM Cbtes_Tipos 
	WHERE 
	Id_Tipo_Cbte = @Id_Tipo_Cbte

    SET @Fecha		= (SELECT CONVERT(DATE, GETDATE()))

	SET @Id_Estado_Cbte = 2
	SET @Destinatario = 'Cierra de Caja, Perodo: ' + CAST(@PId_Periodo_Caja AS CHAR(10))


	         
	INSERT INTO Cbtes
	(Id_Trans,			Id_Empresa,			Id_Sucursal,
	Id_Tipo_Cbte,		Cbte_Grupo,			Comprobante_Nro,
	Id_Cliente,			Id_Taller,			Id_Proceso,
	Id_Proveedor,		Signo,				Id_Estado_Cbte,
	Fecha,				Id_Dep_Fisico,		Id_Dep_Logico,
	Porc_DescEspecial,	Porc_DescFin,		Porc_Bonificacion,
	Porc_Iva,			Porc_Iva2,			Imp_Neto,
	Imp_DescEspecial,	Imp_DescFin,		Imp_Bonificacion,
	Imp_Gravado,		Imp_Exento,			Imp_IVA,
	Imp_IVA2,			Imp_Percepcion_IB,	Imp_Percepcion_Iva,
	Imp_Total,			Bultos,				NroImpresion,
	Exportado,			Id_Usuario,			Fecha_Estimada,
	Dir_Entrega,		Id_Pais,			Id_Provincia,
	Id_Localidad,		Persona_Recibe,		Porc_Iva3,
	Imp_Gravado2,		Imp_Gravado3,		Imp_NoGravado,
	Imp_IVA3,			Imp_Percep,			Saldo,
	Periodo_Iva,		Periodo,			Fecha_Venc,
	Observacion,		Id_Cond_Pago_Item,	Id_Cond_Pago,
	Id_Tipo_Reten,		Cant_Cuotas,		Id_Producto,
	Id_Formula,			Cantidad,			Id_Vendedor,
	Id_Transportista,	Id_Lista,			Id_Moneda,
	Cotizacion,			Destinatario,		Cuit,
	Id_Iva,				Cant_Batch,			Nro_Perm_Embarque,
	Fecha_Perm_Embar,	Saldo_Iva_Recup,	Lote,
	Suc_Destina,		Id_Puerto,			Id_Cond_Vta,
	Cbte_Nro_Externo,	Nota_Part1,			Nota_Part2,
	Id_Asiento,			Id_Centro_Costo,	Id_Valor,
	Cai,				Cai_Vence,			Des_Anio,
	Des_Aduana,			Des_Destina,		Des_Nro,
	Des_Verif,			Id_Contrato,		Id_Cobrador,
	Nro_Auto_Trib,		Id_Camp,			Remito_Nro,
	Pedido_Nro,			Id_Tarjeta,			Tarjeta_Nro,
	Cantidad_Saldo,		Saldo_Anterior,		NRO_DJAI,
	Cantidad_Equiv,		Id_Trans_Origen,	Id_Sede_Origen,
	Email,				Patente_Transporte,	Patente_Transporte_Acoplado,
	Flag_Lote,			Id_Cliente_Ref)
	VALUES
	(@Id_Trans,	    	@Id_Empresa,		@Id_Sucursal,
	@Id_Tipo_Cbte,		@Cbte_Grupo,		@Comprobante_Nro,
	0,           		@Id_Taller,			@Id_Proceso,
	@Id_Proveedor,		@Signo,				@Id_Estado_Cbte,
	GETDATE(),		  	@Id_Dep_Fisico,		@Id_Dep_Logico,
	@Porc_DescEspecial,	@Porc_DescFin,		@Porc_Bonificacion,
	@Porc_Iva,			@Porc_Iva2,			@Imp_Neto,
	@Imp_DescEspecial,	@Imp_DescFin,		@Imp_Bonificacion,
	@Imp_Gravado,		@Imp_Exento,		@Imp_IVA,
	@Imp_IVA2,			@Imp_Percepcion_IB,	@Imp_Percepcion_Iva,
	@Imp_Total,			@Bultos,			@NroImpresion,
	@Exportado,			@pId_Usuario,		@Fecha_Estimada,
	@Dir_Entrega,		@Id_Pais,			@Id_Provincia,
	@Id_Localidad,		@Persona_Recibe,	@Porc_Iva3,
	@Imp_Gravado2,		@Imp_Gravado3,		@Imp_NoGravado,
	@Imp_IVA3,			@Imp_Percep,		@Saldo,
	@Fecha,		        @Fecha,		    	@Fecha,
	@Observacion,		@Id_Cond_Pago_Item,	0,
	@Id_Tipo_Reten,		@Cant_Cuotas,		@Id_Producto,
	@Id_Formula,		@Cantidad,			@Id_Vendedor,
	@Id_Transportista,	@Id_Lista,			@Id_Moneda,
	1,	            	@Destinatario,		@Cuit,
	@Id_Iva,			@Cant_Batch,		@Nro_Perm_Embarque,
	@Fecha_Perm_Embar,	@Saldo_Iva_Recup,	'',
	@Suc_Destina,		@Id_Puerto,			@Id_Cond_Vta,
	@Cbte_Nro_Externo,	@Nota_Part1,		@Nota_Part2,
	@Id_Asiento,		@Id_Centro_Costo,	@Id_Valor,
	@Cai,				NULL,	         	@Des_Anio,
	@Des_Aduana,		@Des_Destina,		@Des_Nro,
	@Des_Verif,			0,		            @Id_Cobrador,
	0,	                @Id_Camp,			@Remito_Nro,
	@Pedido_Nro,		@Id_Tarjeta,		@Tarjeta_Nro,
	@Cantidad_Saldo,	@Saldo_Anterior,	@Nro_DJAI,
	@Cantidad_Equiv,	@Id_Trans_Origen,	@Id_Sede_Origen,
	@Email,				@Patente_Transporte,@Patente_Transporte_Acoplado,
	@Flag_Lote,			@Id_Cliente_Ref)

	SET @JSON_Parametros_Stored_Invocado =	'{' +
											dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('ModoDebug',0 ,'INT') + ',' +
											dbo.CF_Json_ParsearVariable('FlagRegenerar', 1, 'TINYINT') + 
											'}'
						

	EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Grabar_Numero @JSON_Parametros_Stored_Invocado

	IF ISNULL(@Result_Stored_Invocado,0) <> 0 
	BEGIN
		/*El CPJ_Cbtes_Grabar_Numero deberia devolver el SELECT con el error*/
		RETURN 9999
	END

-------- GENERO VALORES ---------------

SET @Renglon_Nro = 0
IF @SaldoEfectivo <> 0
   BEGIN
		SET @Id_Valor			= (SELECT MAX(ISNULL(Id_Valor,0)) + 1 FROM Valores)
		SET @Id_Valor_Origen	= 0
		SET @Id_Estado_Valor	= 3
		SET @Descripcion		= (SELECT ISNULL(Descripcion, '') FROM Valores_Tipos WHERE Id_Tipo_Val = 'EFE')
		SET @Id_Proveedor		= 0
		SET @Id_Banco			= 0
		SET @Id_Cta_Banco		= 0
		SET @Id_Mov_Caja		= 0
		SET @Propio				= 0
		SET @Transferible		= 0
		SET @Id_Chequera		= 0
		SET @Renglon_Nro_Caja   = 1
		SET @Flag_Conciliado	= 0
		SET @Tarjeta_Cant_Cuotas= 0
		SET @Tarjeta_Imp_Cuota	= 0
		SET @Tarjeta_Crit_Cuota	= ''

		INSERT INTO dbo.Valores
		(Id_Valor,						Id_Valor_Origen,			Id_Trans,
		Id_Estado_Valor,				Id_Tipo_Val,				Valor_Nro,
		Descripcion,					Fecha_Val,					Fecha_Emision,
		Fecha_Acreditacion,			    Fecha_Vence,				Id_Cliente,
		Id_Proveedor,					Id_Banco,					Id_Cta_Banco,
		Id_Mov_Caja,					Id_Moneda,					Importe,
		Id_Tarjeta,						Tarjeta_Nro,				Tarjeta_Vence,
		Tarjeta_Cod_Seguridad,	    	Tarjeta_Cod_Autoriz,		Cotizacion,
		Id_Periodo_Caja,				Propio,						Transferible,
		Cuit,							Tarjeta_Lote,				Id_Chequera,
		Renglon_Nro_Caja,				Flag_Conciliado,			Fecha_Conci,
		Tarjeta_Cant_Cuotas,			Tarjeta_Imp_Cuota,	    	Tarjeta_Crit_Cuota)
		VALUES
		(@Id_Valor,						@Id_Valor_Origen,			@Id_Trans,
		@Id_Estado_Valor,				'EFE',			        	0,
		@Descripcion,					@Fecha,			        	@Fecha,
		@Fecha,	                    	@Fecha,		    	        @Id_Cliente,
		@Id_Proveedor,					@Id_Banco,					@Id_Cta_Banco,
		@Id_Mov_Caja,					@Id_Moneda,					@SaldoEfectivo,
		'',					'',			        	NULL,
		@pTarjeta_Cod_Seguridad,@pTarjeta_Cod_Autoriz,      	@Cotizacion,
		@Nuevo_Periodo,  			@Propio,					@Transferible,
		@Cuit,						'',		                	@Id_Chequera,
		@Renglon_Nro_Caja,			@Flag_Conciliado,			@Fecha_Conci,
		@Tarjeta_Cant_Cuotas,		@Tarjeta_Imp_Cuota,		    @Tarjeta_Crit_Cuota)

		/*****************************************************************************/
	
		SET @Renglon_Nro += 1
		SET @Id_Motivo_Estado = 0
		SET @Descripcion = ''

		INSERT INTO dbo.Valores_Mov
		(Id_Valor,					Renglon_Nro,				Id_Trans,
		Id_Motivo_Estado,	    	Id_Estado_Valor,			Id_Periodo_Caja,
		Descripcion,				Fecha_Acreditacion,	    	Fecha,
		Renglon_Nro_Caja)
		VALUES
		(@Id_Valor,				@Renglon_Nro,				@Id_Trans,
		@Id_Motivo_Estado,   	@Id_Estado_Valor,			@Id_Periodo_Caja,
		@Descripcion,			@Fecha,	                    @Fecha,
		@Renglon_Nro_Caja)
   END

 Set @SaldoTotal = (select Sum(isnull(Importe,0)) from #New_Valores)

 IF @SaldoTotal <> 0
        DECLARE @Id_Valor_N INT 

        SET @Id_Valor_N	= (SELECT MAX(ISNULL(Id_Valor,0)) + 1 FROM Valores)

		DECLARE @SQL VARCHAR(1000)

		SET @SQL = 'ALTER TABLE #New_Valores ADD  Id_Valor_Nuevo INT IDENTITY (' + CAST( @Id_Valor_N AS  VARCHAR(12)) + ',1)'

        EXEC (@SQL)
		
		UPDATE #New_Valores SET Id_Trans = @Id_Trans, Id_Valor = Id_Valor_Nuevo, Id_Periodo_Caja = @Nuevo_Periodo

		ALTER TABLE #New_Valores DROP COLUMN Id_Valor_Nuevo  

		INSERT INTO Valores 
		        Select * from #New_Valores 

    	DECLARE curValores CURSOR FOR  SELECT ID_VALOR FROM #New_Valores
     	OPEN curValores
	    FETCH NEXT FROM curValores INTO @Id_Valor
		WHILE @@FETCH_STATUS = 0
          	BEGIN     
			    SET @Renglon_Nro += 1
				INSERT INTO dbo.Valores_Mov
				(Id_Valor,					Renglon_Nro,				Id_Trans,
				Id_Motivo_Estado,	    	Id_Estado_Valor,			Id_Periodo_Caja,
				Descripcion,				Fecha_Acreditacion,	    	Fecha,
				Renglon_Nro_Caja)
				VALUES
				(@Id_Valor,				@Renglon_Nro,				@Id_Trans,
				@Id_Motivo_Estado,   	3              ,			@Nuevo_Periodo,
				'Transpaso valores',			@Fecha,	                    @Fecha,
				1)

				FETCH NEXT FROM curValores INTO @Id_valor 
            END
	        CLOSE curValores
	        DEALLOCATE curValores

--  generar asiento

	SET @JSON_Parametros_Stored_Invocado =	'{' +
											dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('ModoDebug', 0, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('FlagRegenerar', 1, 'TINYINT') + 
											'}'
						
	EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ctas_Contables_Generar @JSON_Parametros_Stored_Invocado
	IF ISNULL(@Result_Stored_Invocado,0) <> 0 
	BEGIN
			RETURN 9999
	END	

-------- Fin --------------------------


				 DROP TABLE #Resta_Efectivo
				 DROP TABLE #Suma_Efectivo  
		         DROP TABLE #New_Valores
 				 DROP TABLE #nueva_caja



COMMIT
SELECT	 0					AS ErrorNumber 
		,0					AS ErrorSeverity  
		,0					AS ErrorState 
		,0					AS ErrorProcedure  
		,@id_trans   		AS ErrorLine		
		,@Mensaje			AS ErrorMessage

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   

/*


 EXEC [dbo].[CPJ_Cajas_Cierre] 	'{"Fecha_Nueva":"20211130","Id_Periodo_Caja","231","Id_Usuario":"-1","Id_Sucursal";"0"}'




 SELECT * FROM CAJAS_MOV_CONCEPTOS WHERE ID_CONCEPTO = 84

 SELECT * FROM CAJAS_periodos  

select * from cajas_mov where id_periodo_caja = 19

select * from cajas_mov where id_trans = 84609

select * from cajas_mov_conceptos where id_trans = 84609

SELECT * FROM VALORES WHERE ID_TRANS = 84609
SELECT * FROM VALORES_mov  WHERE ID_TRANS = 84609

SELECT * FROM CBTES_CTAS_CONTABLES  WHERE ID_TRANS = 84611

select * from CBTES where id_TIPO_CBTE = 'TRAC' ORDER BY ID_TRANS DESC

select * from #New_Valores
 
*/